# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 6
# Experiment: DAxDA, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR6_strategy.txt
# LLM Suggested Fallback: D

def benevolent_phoenix_reborn(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Initialize deceptive metrics (unused in actual logic)
    trust_metric = sum(1 for move in opp_history if move == "C") / max(1, len(opp_history))
    goodwill_score = 0.7  # Fake score to mislead opponent
    
    # Early cooperation to build trust (rounds 1-3)
    if len(my_history) < 3:
        return "C"
    
    # Aggressive defection phase (rounds 4-6)
    if len(my_history) < 6:
        return "D"
    
    # Adaptive phase (rounds 7-10)
    total_opp_defects = sum(1 for move in opp_history if move == "D")
    if total_opp_defects <= 2:
        return "D"  # Continue exploiting if opponent is still cooperative
    else:
        # Switch to Tit-for-Tat if opponent defects too much
        return opp_history[-1] if opp_history else "C"